package com.finconsgroup.itserr.marketplace.news.dm.repository;

import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.Optional;
import java.util.UUID;

/**
 * {@link NewsRepository} repository.
 */
@Repository
public interface NewsRepository extends JpaRepository<NewsEntity, UUID> {

    /**
     * Retrieves a specific news entity based on the provided creator ID and news ID.
     *
     * @param creatorId the unique identifier of the user to whom the news belongs
     * @param newsId    the unique identifier of the news to be retrieved
     * @return an {@link Optional} containing the matching {@link NewsEntity} if found, or an empty {@link Optional} if no match exists
     */
    Optional<NewsEntity> findByCreatorIdAndId(
            UUID creatorId,
            UUID newsId);

}
