package com.finconsgroup.itserr.marketplace.news.dm.mapper;

import com.finconsgroup.itserr.marketplace.news.dm.dto.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import org.mapstruct.AfterMapping;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValueMappingStrategy;

@Mapper(config = MapperConfiguration.class, uses = {AuthorMapper.class})
public interface NewsMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "creatorId", ignore = true)
    @Mapping(target = "imageId", source = "image.id")
    @Mapping(target = "imageUrl", source = "image.url")
    NewsEntity toEntity(InputCreateNewsDto inputCreateNewsDto);

    @Mapping(target = "image.id", source = "imageId")
    @Mapping(target = "image.url", source = "imageUrl")
    @Mapping(target = "tags", source = "tags", defaultExpression = "java(java.util.Collections.emptyList())")
    @Mapping(target = "registeredAuthorIds", source = "registeredAuthorIds", defaultExpression = "java(java.util.Collections.emptyList())")
    @IterableMapping(nullValueMappingStrategy = NullValueMappingStrategy.RETURN_DEFAULT)
    OutputNewsDto toDto(NewsEntity newsEntity);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "creatorId", ignore = true)
    @Mapping(target = "imageId", source = "image.id")
    @Mapping(target = "imageUrl", source = "image.url")
    void updateEntity(InputUpdateNewsDto dto, @MappingTarget NewsEntity entity);

    @AfterMapping
    default void setUnregisteredAuthors(@MappingTarget NewsEntity newsEntity) {
        if (newsEntity != null && newsEntity.getUnRegisteredAuthors() != null) {
            newsEntity.getUnRegisteredAuthors().forEach(authorEntity -> authorEntity.setNews(newsEntity));
        }
    }
}
