package com.finconsgroup.itserr.marketplace.news.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO representing a created news.
 */
@Schema(name = "OutputNewsDto", description = "DTO representing a news in responses")
@Data
@Builder
@AllArgsConstructor
public class OutputNewsDto {

    @Schema(description = "Unique identifier of the news", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "The title of the news", example = "Annual Tech Conference 2025")
    private String title;

    @Schema(description = "The ID of the creator", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID creatorId;

    @Schema(description = "The type of news", example = "Technology")
    private String newsType;

    @Schema(description = "The content of the news")
    private String content;

    @Schema(description = "List of tags associated with the news")
    private List<String> tags;

    @Schema(description = "List of institutional pages")
    private List<OutputInstitutionalPageDto> institutionalPages;

    @Schema(description = "Image")
    private OutputImageDto image;

    @Schema(description = "List of unregistered authors")
    private List<OutputAuthorDto> unRegisteredAuthors;

    @Schema(description = "List of registered authors", example = "[\"123e4567-e89b-12d3-a456-426614174002\", \"123e4567-e89b-12d3-a456-426614174003\"]")
    private List<String> registeredAuthorIds;

    @Schema(description = "The creation time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant updateTime;
}
