package com.finconsgroup.itserr.marketplace.news.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Output DTO for a location.
 */
@Schema(name = "OutputLocationDto", description = "DTO representing a location in responses")
@Data
@Builder
@AllArgsConstructor
public class OutputLocationDto {

    @Schema(description = "City", example = "Palo Alto")
    private String city;

    @Schema(description = "Region or State", example = "CA")
    private String region;

    @Schema(description = "Country", example = "USA")
    private String country;

    @Schema(description = "ZipCode", example = "90100")
    private String zipCode;
}

