package com.finconsgroup.itserr.marketplace.news.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.news.dm.util.ValidationConstants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.dm.util.ValidationConstants.VALIDATION_LOCATION_LENGTH;

/**
 * Input DTO for creating a location.
 */
@Schema(name = "InputLocationDto", description = "DTO for creating a location")
@Data
@Builder
@AllArgsConstructor
public class InputLocationDto {

    @Schema(description = "City", example = "Palo Alto")
    @Size(max = VALIDATION_LOCATION_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String city;

    @Schema(description = "Region or State", example = "CA")
    @Size(max = VALIDATION_LOCATION_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String region;

    @Schema(description = "Country", example = "USA")
    @Size(max = VALIDATION_LOCATION_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String country;

    @Schema(description = "ZipCode", example = "90100")
    @Size(max = VALIDATION_LOCATION_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String zipCode;
}

