/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedNewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.mapper.ArchivedNewsMapper;
import com.finconsgroup.itserr.marketplace.news.dm.mapper.NewsMapper;
import com.finconsgroup.itserr.marketplace.news.dm.repository.ArchivedNewsRepository;
import com.finconsgroup.itserr.marketplace.news.dm.repository.NewsRepository;
import com.finconsgroup.itserr.marketplace.news.dm.service.NewsService;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultNewsService
implements NewsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNewsService.class);
    private final NewsRepository newsRepository;
    private final NewsMapper newsMapper;
    private final ArchivedNewsRepository archivedNewsRepository;
    private final ArchivedNewsMapper archivedNewsMapper;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputNewsDto> findAll(@NonNull Pageable pageable) {
        return this.newsRepository.findAll(pageable).map(arg_0 -> ((NewsMapper)this.newsMapper).toDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputNewsDto findById(@NonNull UUID newsId) {
        NewsEntity newsEntity = (NewsEntity)this.newsRepository.findById((Object)newsId).orElseThrow(() -> new WP2ResourceNotFoundException(newsId));
        return this.newsMapper.toDto(newsEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputNewsDto create(@NonNull UUID userId, @NotNull InputCreateNewsDto inputCreateNewsDto) {
        NewsEntity newsEntity = this.newsMapper.toEntity(inputCreateNewsDto);
        newsEntity.setCreatorId(userId);
        return this.newsMapper.toDto((NewsEntity)this.newsRepository.saveAndFlush((Object)newsEntity));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputNewsDto updateById(@NonNull UUID userId, @NotNull UUID newsId, @NotNull InputUpdateNewsDto inputUpdateNewsDto) {
        NewsEntity newsEntity = this.findByIdOrThrow(userId, newsId);
        this.newsMapper.updateEntity(inputUpdateNewsDto, newsEntity);
        NewsEntity savedNewsEntity = (NewsEntity)this.newsRepository.save((Object)newsEntity);
        return this.newsMapper.toDto(savedNewsEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(@NonNull UUID userId, @NotNull UUID newsId) {
        NewsEntity newsEntity = this.findByIdOrThrow(userId, newsId);
        ArchivedNewsEntity archivedNewsEntity = this.archivedNewsMapper.toArchivedEntity(newsEntity);
        this.archivedNewsRepository.save((Object)archivedNewsEntity);
        this.newsRepository.deleteById((Object)newsId);
    }

    private NewsEntity findByIdOrThrow(@NonNull UUID userId, @NonNull UUID newsId) {
        return (NewsEntity)this.newsRepository.findByCreatorIdAndId(userId, newsId).orElseThrow(() -> new WP2ResourceNotFoundException(newsId));
    }

    @Generated
    public DefaultNewsService(NewsRepository newsRepository, NewsMapper newsMapper, ArchivedNewsRepository archivedNewsRepository, ArchivedNewsMapper archivedNewsMapper) {
        this.newsRepository = newsRepository;
        this.newsMapper = newsMapper;
        this.archivedNewsRepository = archivedNewsRepository;
        this.archivedNewsMapper = archivedNewsMapper;
    }
}

