/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.dm.mapper;

import com.finconsgroup.itserr.marketplace.news.dm.dto.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.mapper.AuthorMapper;
import com.finconsgroup.itserr.marketplace.news.dm.mapper.MapperConfiguration;
import org.mapstruct.AfterMapping;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValueMappingStrategy;

@Mapper(config=MapperConfiguration.class, uses={AuthorMapper.class})
public interface NewsMapper {
    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="creatorId", ignore=true), @Mapping(target="imageId", source="image.id"), @Mapping(target="imageUrl", source="image.url")})
    public NewsEntity toEntity(InputCreateNewsDto var1);

    @Mappings(value={@Mapping(target="image.id", source="imageId"), @Mapping(target="image.url", source="imageUrl"), @Mapping(target="tags", source="tags", defaultExpression="java(java.util.Collections.emptyList())"), @Mapping(target="registeredAuthorIds", source="registeredAuthorIds", defaultExpression="java(java.util.Collections.emptyList())")})
    @IterableMapping(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT)
    public OutputNewsDto toDto(NewsEntity var1);

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="creatorId", ignore=true), @Mapping(target="imageId", source="image.id"), @Mapping(target="imageUrl", source="image.url")})
    public void updateEntity(InputUpdateNewsDto var1, @MappingTarget NewsEntity var2);

    @AfterMapping
    default public void setUnregisteredAuthors(@MappingTarget NewsEntity newsEntity) {
        if (newsEntity != null && newsEntity.getUnRegisteredAuthors() != null) {
            newsEntity.getUnRegisteredAuthors().forEach(authorEntity -> authorEntity.setNews(newsEntity));
        }
    }
}

