package com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Output DTO response for an Institutional Page.
 */
@Schema(name = "OutputInstitutionalPageDto", description = "DTO response for an Institutional Page")
@Data
@Builder
@AllArgsConstructor
public class OutputInstitutionalPageDto {

    @Schema(description = "ID of the Institutional Page", example = "123e4567-e89b-12d3-a456-426614174002")
    private UUID id;

    @Schema(description = "Name of Institutional Page", example = "WP3 - T-Res")
    private String name;
}

