/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.client;

import com.finconsgroup.itserr.marketplace.news.bs.client.dto.workspace.FolderDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.workspace.InputFolderCreateDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.workspace.OutputPublicImageDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.workspace.WorkspaceDto;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.constraints.NotBlank;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

public interface WorkspaceBsClient {
    @GetMapping(path={"/workspace"}, produces={"application/json"})
    public WorkspaceDto getWorkspace();

    @PostMapping(path={"workspace/folders/{folderId}/folders"}, produces={"application/json"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public String createFolderByFolderId(@PathVariable @NotBlank String var1, @RequestBody InputFolderCreateDto var2);

    @ApiResponses(value={@ApiResponse(responseCode="200", description="Folder found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="404", description="Folder not found")})
    @GetMapping(path={"workspace/folders/{folderId}/folder-by-name"}, produces={"application/json"})
    public FolderDto getFolderByParentFolderIdAndName(@PathVariable String var1, @RequestParam String var2);

    @PostMapping(path={"/workspace/images/public/{folderId}"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public OutputPublicImageDto createPublicImage(@PathVariable(name="folderId") String var1, @RequestPart(name="file") MultipartFile var2);

    @PutMapping(path={"/workspace/images/public/{documentId}"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public OutputPublicImageDto updatePublicImage(@PathVariable(name="documentId") String var1, @RequestPart(name="file") MultipartFile var2);
}

