package com.finconsgroup.itserr.marketplace.news.bs.messaging;

import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import org.springframework.lang.NonNull;

/**
 * Message Producer responsible for publishing news-related resource messages
 */
public interface ResourceProducer {

    /**
     * Publishes a message for created resource.
     *
     * @param resource the resource that was created
     */
    void publishCreatedResource(@NonNull OutputNewsDetailDto resource);

    /**
     * Publishes a message for updated resource.
     *
     * @param resource the resource that was updated
     */
    void publishUpdatedResource(@NonNull OutputNewsDetailDto resource);

    /**
     * Publishes a message for deleted resource.
     *
     * @param resource the resource that was deleted
     */
    void publishDeletedResource(@NonNull OutputNewsDetailDto resource);
}
