package com.finconsgroup.itserr.marketplace.news.bs.client;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.userprofile.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.userprofile.OutputUserProfileDto;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Feign client for communication with the UserProfile DM service.
 */
public interface UserProfileDmClient {

    /**
     * Retrieves all user profiles for the provided ids.
     *
     * @param dto        the input data transfer object containing find user profile by ids details
     * @param pageNumber the page number to retrieve (default is 0)
     * @param pageSize   the number of user profiles per page (default is 10)
     * @param sort       the field to sort by (default is "id")
     * @param direction  the direction of sorting (default is ASC)
     * @return a {@link OutputPageDto<OutputUserProfileDto>} and HTTP status 200 (OK)
     */
    @PostMapping("/profiles-by-ids")
    OutputPageDto<OutputUserProfileDto> findAllByIds(
            @RequestBody InputFindUserProfilesByIdsDto dto,
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name = "sort") String sort,
            @RequestParam(name = "direction") SortDirection direction
    );


}
