package com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

/**
 * Enum representing different types of metrics that can be tracked.
 */
@Getter
public enum MetricDtoType {

    /** Tracks when a user downloads a catalog item */
    @JsonProperty("catalog-item-download")
    CATALOG_ITEM_DOWNLOAD,

    /** Tracks when a user views a catalog item */
    @JsonProperty("catalog-item-view")
    CATALOG_ITEM_VIEW,

    /** Tracks when a user marks a catalog item as favorite */
    @JsonProperty("catalog-item-favourite")
    CATALOG_ITEM_FAVOURITE,

    /** Tracks when a user comments on a catalog item */
    @JsonProperty("catalog-item-comment")
    CATALOG_ITEM_COMMENT,

}
