package com.finconsgroup.itserr.marketplace.metrics.feeder.config.properties;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties class for metrics feeder application settings.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Validated
@ConfigurationProperties(prefix = "metrics.feeder")
public class MetricsFeederConfigurationProperties {

    /**
     * Configuration properties for messaging-related settings. This field is required and cannot be null.
     */
    @NotNull
    @Valid
    private MessagingConfigurationProperties messaging;

}
