package com.finconsgroup.itserr.marketplace.metrics.bs.api;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricEventDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * This interface defines the contract for REST API endpoints used for system testing and debugging.
 *
 * <p>
 * These endpoints are intended for internal use only and provide endpoints used for debugging and runtime analysis.
 * </p>
 *
 * <p>Example usage:
 * <pre>
 * GET /api/v1/bs/diagnostics/download-logs - Download application log for analysis
 * </pre>
 * </p>
 */
@Tag(
        name = "Diagnostics",
        description = "Diagnostics API: provides endpoints used for " +
                "debugging and runtime analysis."
)
@SecurityRequirement(name = "BearerAuth")
public interface DiagnosticsApi {

    @Operation(
            summary = "Download log file",
            responses = { @ApiResponse(responseCode = "200", description = "OK"), }
    )
    @GetMapping(path = "/metrics/diagnostics/download-logs", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    ResponseEntity<Resource> downloadLogs();

    /**
     * Creates a new metricEvent.
     *
     * @param metric the metric type
     * @param inputCreateMetricEventDto the input data transfer object containing metricEvent details
     * @return the created {@link OutputMetricEventDto} and HTTP status 201 (Created)
     */
    @Operation(
            summary = "create metricEvent",
            responses = { @ApiResponse(responseCode = "201", description = "Created") }
    )
    @PostMapping(
            value = "/metrics/diagnostics/metrics/{metricId}/events",
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE
    )
    @ResponseStatus(HttpStatus.CREATED)
    OutputMetricEventDto createMetricEvent(
            @PathVariable("metricId") MetricDtoType metric,
            @Valid @RequestBody InputCreateMetricEventDto inputCreateMetricEventDto);

}
