/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.repository;

import com.finconsgroup.itserr.marketplace.catalog.bs.client.ItemClient;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.ItemStatus;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputItemDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputCatalogItemMinimalDto;
import feign.FeignException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class CatalogRepository {
    private final ItemClient itemClient;

    public Optional<OutputItemDto> findById(@NonNull UUID id) {
        try {
            return Optional.of(this.itemClient.getItemById(id));
        }
        catch (WP2ResourceNotFoundException | FeignException.NotFound e) {
            return Optional.empty();
        }
    }

    @NonNull
    public Set<String> getUserItemIds(@NonNull UUID userId) {
        Set<String> itemIds = this.itemClient.getAllItems(0, Integer.MAX_VALUE, null, null, null, null, null, userId, ItemStatus.APPROVED, null).getContent().stream().map(OutputItemDto::getId).filter(Objects::nonNull).map(UUID::toString).collect(Collectors.toSet());
        return itemIds;
    }

    @NonNull
    public List<OutputCatalogItemMinimalDto> getUserItems(@NonNull UUID userId) {
        List<OutputCatalogItemMinimalDto> items = this.itemClient.getAllItems(0, Integer.MAX_VALUE, null, null, null, null, null, userId, ItemStatus.APPROVED, null).getContent().stream().map(arg_0 -> this.mapToOutputItemMinimalDto(arg_0)).toList();
        return items;
    }

    private OutputCatalogItemMinimalDto mapToOutputItemMinimalDto(OutputItemDto outputItemDto) {
        return OutputCatalogItemMinimalDto.builder().id(outputItemDto.getId().toString()).title(outputItemDto.getTitle()).build();
    }

    @Generated
    public CatalogRepository(ItemClient itemClient) {
        this.itemClient = itemClient;
    }
}

