package com.finconsgroup.itserr.marketplace.metrics.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.LocalDate;

/**
 * Data Transfer Object (DTO) representing metrics data for a specific date. This class combines a date with its associated metrics information.
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetricsInfoAtDateDto extends OutputMetricsInfoDto {

    /**
     * The date for which the metrics are recorded.
     */
    @Schema(description = "The date for which the metrics are recorded", example = "2025-11-07")
    private LocalDate date;

}
