/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.client;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics.OutputMetricsInterestWeightsConfigurationDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics.OutputResourcesSummaryMetricsDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.time.LocalDate;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

public interface MetricDmClient {
    @PostMapping(value={"/metrics/metrics/{metricId}/events"}, consumes={"application/json"}, produces={"application/json"})
    public OutputMetricEventDto createMetricEvent(@PathVariable(value="metricId") String var1, @Valid @RequestBody InputCreateMetricEventDto var2);

    @GetMapping(value={"/metrics/metrics-summaries"}, produces={"application/json"})
    public OutputResourcesSummaryMetricsDto findResourcesSummaryMetrics(@RequestParam(value="resourceId") @NotEmpty Set<String> var1, @RequestParam(value="toDate", required=false) LocalDate var2);

    @Operation(summary="Retrieve metrics interest weight configuration", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/metrics/config/metrics-weights"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputMetricsInterestWeightsConfigurationDto getInterestWeights();
}

