/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration
@EnableCaching
public class CacheConfig {
    @Bean
    @ConditionalOnProperty(name={"metadata.dm.cache.enabled"}, havingValue="true")
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @Primary
    public CacheManager requestScopedCacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        cacheManager.setCaffeine(Caffeine.newBuilder().maximumSize(10L));
        cacheManager.setCacheNames(List.of("metadata"));
        return cacheManager;
    }

    @Bean
    @ConditionalOnProperty(name={"metadata.dm.cache.enabled"}, havingValue="false")
    public CacheManager noOpCacheManager() {
        return new NoOpCacheManager();
    }
}

