/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.authorization;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metadata.dm.authorization.RequireMetadataOwnership;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.MetadataRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.utils.AOPUtils;
import java.util.UUID;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class OwnershipAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OwnershipAspect.class);
    private final MetadataRepository metadataRepository;

    @Around(value="@annotation(requireMetadataOwnership)")
    public Object checkOwnership(ProceedingJoinPoint pjp, RequireMetadataOwnership requireMetadataOwnership) throws Throwable {
        UUID metadataId = (UUID)AOPUtils.extractActualParam((ProceedingJoinPoint)pjp, (String)requireMetadataOwnership.metadataIdParam(), UUID.class);
        MetadataEntity metadata = (MetadataEntity)this.metadataRepository.findById(metadataId).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Metadata not found: %s", metadataId)));
        if (!metadata.getCreatorId().equals(JwtTokenHolder.getUserIdOrThrow())) {
            throw new WP2AuthorizationException(String.format("User %s does not own the Metadata", JwtTokenHolder.getUserIdOrThrow()));
        }
        return pjp.proceed();
    }

    @Generated
    public OwnershipAspect(MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
    }
}

