package com.finconsgroup.itserr.marketplace.metadata.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputInternalFindMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.util.List;

/**
 * This interface defines the contract for internal REST API endpoints related to Metadata Management.
 *
 * <p>
 * It provides endpoints for finding metadata.
 * </p>
 *
 * <p>Example usage:
 * <pre>
 * GET  /internal/metadata - Retrieve a list of all detailed metadata matching criteria.
 * </pre>
 * </p>
 */
@Tag(name = "Metadata (internal)", description = "Internal operations related to metadata")
public interface MetadataInternalApi {

    /**
     * Retrieves detailed metadata matching given criteria.
     *
     * @param request Criteria.
     * @return List of detailed metadata matching given criteria.
     */
    @Operation(
            summary = "Find (internal)",
            description = "Find metadata by criteria and return matching full-detailed metadata",
            security = @SecurityRequirement(name = "bearerAuth"),
            parameters = {
                    @Parameter(
                            name = "id",
                            description = "Metadata id. This parameter can be added multiple times to search for multiple ids.",
                            array = @ArraySchema(schema = @Schema(type = "string"))),
            },
            responses = {
                    @ApiResponse(responseCode = "200", description = "The search result"),
                    @ApiResponse(responseCode = "404", description = "One or more IDs have not been found", content = {
                            @Content(
                                    mediaType = MediaType.APPLICATION_JSON_VALUE,
                                    schema = @Schema(implementation = ErrorResponseDto.class)
                            )
                    }),
            }
    )
    @GetMapping(path = "/internal/metadata", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseStatus(HttpStatus.OK)
    List<OutputMetadataDto> find(
            @ParameterObject @Valid InputInternalFindMetadataDto request);

}
