package com.finconsgroup.itserr.marketplace.metadata.dm.mapper;

import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputCreateMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataFieldEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-12-29T11:31:50+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class MetadataMapperImpl implements MetadataMapper {

    @Autowired
    private MetadataFieldMapper metadataFieldMapper;

    @Override
    public MetadataEntity metadataSaveRequestDtoToMetadataEntity(InputCreateMetadataDto src, UUID userId) {
        if ( src == null && userId == null ) {
            return null;
        }

        MetadataEntity.MetadataEntityBuilder<?, ?> metadataEntity = MetadataEntity.builder();

        if ( src != null ) {
            metadataEntity.name( src.getName() );
            metadataEntity.description( src.getDescription() );
            metadataEntity.category( src.getCategory() );
            metadataEntity.fields( inputCreateMetadataFieldDtoListToMetadataFieldEntityList( src.getFields() ) );
        }
        metadataEntity.creatorId( userId );

        MetadataEntity metadataEntityResult = metadataEntity.build();

        setFieldsMetadataReference( metadataEntityResult );

        return metadataEntityResult;
    }

    @Override
    public OutputMetadataDto metadataEntityToMetadataDto(MetadataEntity src) {
        if ( src == null ) {
            return null;
        }

        OutputMetadataDto.OutputMetadataDtoBuilder outputMetadataDto = OutputMetadataDto.builder();

        outputMetadataDto.id( src.getId() );
        outputMetadataDto.name( src.getName() );
        outputMetadataDto.description( src.getDescription() );
        outputMetadataDto.category( src.getCategory() );
        outputMetadataDto.creatorId( src.getCreatorId() );
        outputMetadataDto.fields( metadataFieldEntityListToOutputMetadataFieldDtoList( src.getFields() ) );

        return outputMetadataDto.build();
    }

    @Override
    public OutputMetadataPreviewDto metadataEntityToMetadataPreviewDto(MetadataEntity src) {
        if ( src == null ) {
            return null;
        }

        OutputMetadataPreviewDto.OutputMetadataPreviewDtoBuilder outputMetadataPreviewDto = OutputMetadataPreviewDto.builder();

        outputMetadataPreviewDto.id( src.getId() );
        outputMetadataPreviewDto.name( src.getName() );
        outputMetadataPreviewDto.description( src.getDescription() );
        outputMetadataPreviewDto.category( src.getCategory() );
        outputMetadataPreviewDto.creatorId( src.getCreatorId() );

        return outputMetadataPreviewDto.build();
    }

    protected List<MetadataFieldEntity> inputCreateMetadataFieldDtoListToMetadataFieldEntityList(List<InputCreateMetadataFieldDto> list) {
        if ( list == null ) {
            return null;
        }

        List<MetadataFieldEntity> list1 = new ArrayList<MetadataFieldEntity>( list.size() );
        for ( InputCreateMetadataFieldDto inputCreateMetadataFieldDto : list ) {
            list1.add( metadataFieldMapper.metadataFieldSaveRequestDtoToMetadataFieldEntity( inputCreateMetadataFieldDto ) );
        }

        return list1;
    }

    protected List<OutputMetadataFieldDto> metadataFieldEntityListToOutputMetadataFieldDtoList(List<MetadataFieldEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<OutputMetadataFieldDto> list1 = new ArrayList<OutputMetadataFieldDto>( list.size() );
        for ( MetadataFieldEntity metadataFieldEntity : list ) {
            list1.add( metadataFieldMapper.metadataFieldEntityToMetadataFieldDto( metadataFieldEntity ) );
        }

        return list1;
    }
}
