package com.finconsgroup.itserr.marketplace.metadata.bs.messaging;

import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import org.springframework.lang.NonNull;

/**
 * Message Producer responsible for publishing metadata-related resource messages
 */
public interface EventProducer {

    /**
     * Publishes an event message for created resource.
     *
     * @param eventDto the resource that was created
     */
    void publishCreateEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an event message for updated resource.
     *
     * @param eventDto the resource that was updated
     */
    void publishUpdateEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an event message for deleted resource.
     *
     * @param eventDto the resource that was deleted
     */
    void publishDeleteEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an event message with resource status (APPROVED or REJECTED).
     *
     * @param eventDto the resource for which status was updated
     */
    void publishStatusEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an event message when moderation is requested for the resource.
     *
     * @param eventDto the resource for which moderation was requested
     */
    void publishModerationRequested(@NonNull MessagingEventDto<?> eventDto);
}
