package com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto;

import com.finconsgroup.itserr.marketplace.metadata.bs.dto.MetadataCategoryEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Metadata create request DTO.
 */
@Schema(
        name = "MetadataCreateRequest",
        description = "Metadata creation request"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InputCreateMetadataDmDto {

    /** Name field length. */
    public static final int NAME_LENGTH = 50;
    /** Description field length. */
    public static final int DESCRIPTION_LENGTH = 2000;

    @Schema(
            description = "Metadata name",
            example = "Dublin Core (DC)")
    @NotBlank
    @Size(max = NAME_LENGTH)
    private String name;

    @Schema(
            description = "Metadata description",
            example = "Standard metadata for digital resources.")
    @Size(max = DESCRIPTION_LENGTH)
    private String description;

    @Schema(description = "Metadata category")
    private MetadataCategoryDmEnum category;

    @Schema(description = "Metadata fields")
    @NotEmpty
    @Valid
    private List<InputCreateMetadataFieldDmDto> fields;

}
