/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.label.dm.controller;

import com.finconsgroup.itserr.marketplace.label.dm.api.LabelApi;
import com.finconsgroup.itserr.marketplace.label.dm.dto.InputCreateLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.dto.OutputLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.service.LabelService;
import java.beans.PropertyEditor;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LabelController
implements LabelApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelController.class);
    private final LabelService labelService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    @NonNull
    public OutputLabelDto create(InputCreateLabelDto dto) {
        return this.labelService.create(dto);
    }

    @NonNull
    public OutputLabelDto get(UUID labelId) {
        return this.labelService.findById(labelId);
    }

    public void delete(UUID labelId) {
        this.labelService.deleteById(labelId);
    }

    @NonNull
    public Page<OutputLabelDto> findByContextAndName(String context, String name, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.labelService.findByContextAndName(context, name, (Pageable)pageable);
    }

    @Generated
    public LabelController(LabelService labelService) {
        this.labelService = labelService;
    }
}

