package com.finconsgroup.itserr.marketplace.label.dm.service;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2DuplicateResourceException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.label.dm.dto.InputCreateLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.dto.OutputLabelDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Service for handling business logic related to label management.
 */
public interface LabelService {
    /**
     * Creates a new label.
     *
     * @param dto Creation request. Cannot be null.
     * @return Created label. Never null.
     * @throws WP2DuplicateResourceException if the label already exists
     */
    @NonNull
    OutputLabelDto create(@NonNull InputCreateLabelDto dto);

    /**
     * Retrieves a label by id.
     *
     * @param labelId the id of the label to retrieve
     * @return an {@link OutputLabelDto} representing the label details
     * @throws WP2ResourceNotFoundException if no label is found with the given id
     */
    @NonNull
    OutputLabelDto findById(@NonNull UUID labelId);

    /**
     * Deletes the label by id.
     *
     * @param labelId the id of the label to delete
     * @throws WP2BusinessException         if delete is not allowed by configuration
     * @throws WP2ResourceNotFoundException if no label is found with the given id
     */
    void deleteById(@NonNull UUID labelId);

    /**
     * Retrieves a page of results of matching label for the given context.
     *
     * @param context  the context to match
     * @param name     the name to match using contains
     * @param pageable the pagination information
     * @return a page of {@link OutputLabelDto} representing the matching labels
     */
    @NonNull
    Page<OutputLabelDto> findByContextAndName(@NonNull String context, String name, @NonNull Pageable pageable);
}
