package com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;

import java.util.UUID;

public class InvalidModerationStatusException extends WP2BusinessException {

    public static final String EXCEPTION_MESSAGE = "Institutional page with id '%s' is in '%s' state, operation not allowed'";

    public InvalidModerationStatusException(UUID institutionalPageId, ModerationStatus status) {
        super(EXCEPTION_MESSAGE.formatted(institutionalPageId, status));
    }
}
