/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstitutionalPageRepository
extends JpaRepository<InstitutionalPageEntity, UUID>,
JpaSpecificationExecutor<InstitutionalPageEntity> {
    public Optional<InstitutionalPageEntity> findByOriginalInstitutionalPageId(UUID var1);

    public List<InstitutionalPageEntity> findAllByParentInstitutionalPageIdInAndModerationStatusIn(List<UUID> var1, List<ModerationStatus> var2);

    public List<InstitutionalPageEntity> findAllByParentInstitutionalPageIdAndOriginalInstitutionalPageIdIsNull(UUID var1);

    @Query(value="select ip.*\nfrom institutional_page ip\nwhere\n    (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))\n    and (:applyInstitutionalPageIdsFilter = false or coalesce(ip.original_institutional_page_id, ip.id) in (:institutionalPageIds))\n    and (:published is null or ip.published = :published)\n    and (:category is null or ip.category = :category)\n    and (:rootLevelOnly = false or ip.parent_institutional_page_id is null)\n    and (:originalVersionOnly = false or ip.original_institutional_page_id is null)\n    and (:latestVersionOnly = false or ip.updated_institutional_page_id is null)\n    and (:searchText is null or lower(ip.name) like lower(concat('%', cast(:searchText as varchar), '%')))\n", countQuery="select count(ip.id)\nfrom institutional_page ip\nwhere\n    (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))\n    and (:applyInstitutionalPageIdsFilter = false or coalesce(ip.original_institutional_page_id, ip.id) in (:institutionalPageIds))\n    and (:published is null or ip.published = :published)\n    and (:category is null or ip.category = :category)\n    and (:rootLevelOnly = false or ip.parent_institutional_page_id is null)\n    and (:originalVersionOnly = false or ip.original_institutional_page_id is null)\n    and (:latestVersionOnly = false or ip.updated_institutional_page_id is null)\n    and (:searchText is null or lower(ip.name) like lower(concat('%', cast(:searchText as varchar), '%')))\n", nativeQuery=true)
    public Page<InstitutionalPageEntity> findAllFiltered(Pageable var1, @Param(value="applyModerationStatusesFilter") boolean var2, @Param(value="moderationStatuses") List<String> var3, @Param(value="applyInstitutionalPageIdsFilter") boolean var4, @Param(value="institutionalPageIds") List<UUID> var5, @Param(value="published") Boolean var6, @Param(value="category") String var7, @Param(value="rootLevelOnly") boolean var8, @Param(value="originalVersionOnly") boolean var9, @Param(value="latestVersionOnly") boolean var10, @Param(value="searchText") String var11);

    @Query(value="SELECT ip.*\nFROM institutional_page ip\nLEFT JOIN institutional_page_member member\n    ON\n    (\n        member.member_id = :userId\n        AND (:wpLeaderOnly = false OR member.wp_lead = true)\n        AND\n        (\n            (\n                member.wp_lead = false\n                AND\n                coalesce(ip.original_institutional_page_id, ip.id) = member.institutional_page_id\n            )\n            OR\n            (\n                member.wp_lead = true\n                AND\n                coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = member.institutional_page_id\n            )\n        )\n    )\nWHERE\n    (:applyModerationStatusesFilter = false OR ip.moderation_status IN (:moderationStatuses))\n    AND (:applyInstitutionalPageIdsFilter = false OR coalesce(ip.original_institutional_page_id, ip.id) IN (:institutionalPageIds))\n    AND (:category IS NULL OR ip.category = :category)\n    AND (:rootLevelOnly = false OR ip.parent_institutional_page_id IS NULL)\n    AND (:searchText IS NULL OR lower(ip.name) LIKE lower(concat('%', cast(:searchText AS varchar), '%')))\n    AND\n    (\n        (\n            member.member_id IS NOT NULL\n            AND\n\t        (\n\t    \t    ( :includePrivateAndMember = true AND ip.published = false )\n                OR\n                ( :includePublishedAndMember = true AND ip.published = true )\n            )\n            AND (:originalVersionOnly = false OR ip.original_institutional_page_id IS NULL)\n            AND (:latestVersionOnly = false OR ip.updated_institutional_page_id IS NULL)\n        )\n        OR\n        (\n            member.member_id IS NULL\n            AND :includePublishedAndNotMember = true\n            AND ip.published = true\n            AND ip.moderation_status = :approvedModerationStatusLabel\n        )\n    )\n", countQuery="SELECT COUNT(ip.id)\nFROM institutional_page ip\nLEFT JOIN institutional_page_member member\n    ON\n    (\n        member.member_id = :userId\n        AND (:wpLeaderOnly = false OR member.wp_lead = true)\n        AND\n        (\n            (\n                member.wp_lead = false\n                AND\n                coalesce(ip.original_institutional_page_id, ip.id) = member.institutional_page_id\n            )\n            OR\n            (\n                member.wp_lead = true\n                AND\n                coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = member.institutional_page_id\n            )\n        )\n    )\nWHERE\n    (:applyModerationStatusesFilter = false OR ip.moderation_status IN (:moderationStatuses))\n    AND (:applyInstitutionalPageIdsFilter = false OR coalesce(ip.original_institutional_page_id, ip.id) IN (:institutionalPageIds))\n    AND (:category IS NULL OR ip.category = :category)\n    AND (:rootLevelOnly = false OR ip.parent_institutional_page_id IS NULL)\n    AND (:searchText IS NULL OR lower(ip.name) LIKE lower(concat('%', cast(:searchText AS varchar), '%')))\n    AND\n    (\n        (\n            member.member_id IS NOT NULL\n            AND\n\t        (\n\t    \t    ( :includePrivateAndMember = true AND ip.published = false )\n                OR\n                ( :includePublishedAndMember = true AND ip.published = true )\n            )\n            AND (:originalVersionOnly = false OR ip.original_institutional_page_id IS NULL)\n            AND (:latestVersionOnly = false OR ip.updated_institutional_page_id IS NULL)\n        )\n        OR\n        (\n            member.member_id IS NULL\n            AND :includePublishedAndNotMember = true\n            AND ip.published = true\n            AND ip.moderation_status = :approvedModerationStatusLabel\n        )\n    )\n", nativeQuery=true)
    public Page<InstitutionalPageEntity> findAllForMemberFiltered(Pageable var1, @Param(value="userId") UUID var2, @Param(value="wpLeaderOnly") boolean var3, @Param(value="applyModerationStatusesFilter") boolean var4, @Param(value="moderationStatuses") List<String> var5, @Param(value="applyInstitutionalPageIdsFilter") boolean var6, @Param(value="institutionalPageIds") List<UUID> var7, @Param(value="includePrivateAndMember") boolean var8, @Param(value="includePublishedAndMember") boolean var9, @Param(value="includePublishedAndNotMember") boolean var10, @Param(value="category") String var11, @Param(value="rootLevelOnly") boolean var12, @Param(value="originalVersionOnly") boolean var13, @Param(value="latestVersionOnly") boolean var14, @Param(value="searchText") String var15, @Param(value="approvedModerationStatusLabel") String var16);

    @Query(value="select ip.*\nfrom institutional_page ip\njoin institutional_page_member member\n    on\n    (\n        member.member_id = :userId\n        and member.institutional_page_id = :rootInstitutionalPageId\n        and member.wp_lead = true\n        and coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = member.institutional_page_id\n    )\nwhere\n    (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))\n    and (:originalVersionOnly = false or ip.original_institutional_page_id is null)\n", countQuery="select count(ip.id)\nfrom institutional_page ip\njoin institutional_page_member member\n    on\n    (\n        member.member_id = :userId\n        and member.institutional_page_id = :rootInstitutionalPageId\n        and member.wp_lead = true\n        and coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = member.institutional_page_id\n    )\nwhere\n    (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))\n    and (:originalVersionOnly = false or ip.original_institutional_page_id is null)\n", nativeQuery=true)
    public Page<InstitutionalPageEntity> findHierarchyForMemberFiltered(Pageable var1, @Param(value="userId") UUID var2, @Param(value="rootInstitutionalPageId") UUID var3, @Param(value="applyModerationStatusesFilter") boolean var4, @Param(value="moderationStatuses") List<String> var5, @Param(value="originalVersionOnly") boolean var6);

    @Query(value="select ip.*\nfrom institutional_page ip\nwhere\n    coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = :rootInstitutionalPageId\n    and (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))\n    and (:originalVersionOnly = false or ip.original_institutional_page_id is null)\n", countQuery="select count(ip.id)\nfrom institutional_page ip\nwhere\n    coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = :rootInstitutionalPageId\n    and (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))\n    and (:originalVersionOnly = false or ip.original_institutional_page_id is null)\n", nativeQuery=true)
    public Page<InstitutionalPageEntity> findHierarchyFiltered(Pageable var1, @Param(value="rootInstitutionalPageId") UUID var2, @Param(value="applyModerationStatusesFilter") boolean var3, @Param(value="moderationStatuses") List<String> var4, @Param(value="originalVersionOnly") boolean var5);
}

