package com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchModerationInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputRelatedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.InstitutionalPageView;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchForMemberInstitutionalPageModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchInstitutionalPageModel;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingConstants;
import org.mapstruct.MappingTarget;
import org.mapstruct.ValueMapping;
import org.mapstruct.ValueMappings;

@Mapper(
        config = MapperConfiguration.class,
        uses = {
                MemberMapper.class,
                ParagraphMapper.class
        }
)
public interface InstitutionalPageMapper {

    @Mapping(target = "parentInstitutionalPageId", ignore = true) // will be set manually if needed
    @Mapping(target = "ancestorInstitutionalPageIds", ignore = true) // will be set manually
    @Mapping(target = "moderationStatus", ignore = true) // will be set manually
    @Mapping(target = "members", ignore = true) // will be set manually
    @Mapping(target = "publicationTime", ignore = true) // will be set manually
    @Mapping(target = "originalInstitutionalPageId", ignore = true) // will be set manually
    @Mapping(target = "updatedInstitutionalPageId", ignore = true) // will be set manually
    @Mapping(target = "rejectionMessage", ignore = true) // will be set manually
    @Mapping(target = "maintainer", ignore = true) // will be set manually
    @Mapping(target = "updateLockedBy", ignore = true) // will be set manually if needed
    @Mapping(target = "lastModifiedBy", ignore = true) // will be set manually
    @Mapping(target = "toDelete", ignore = true) // will be set manually
    @Mapping(target = "copyrightText", source = "copyright.text")
    @Mapping(target = "copyrightYear", source = "copyright.year")
    @Mapping(target = "repoName", source = "repositories.repoName")
    @Mapping(target = "website", source = "repositories.website")
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    InstitutionalPageEntity toEntity(InputCreateInstitutionalPageDto dto);

    @Mapping(target = "rootInstitutionalPageName", ignore = true) // will be set manually
    @Mapping(target = "parentInstitutionalPage", ignore = true) // will be set manually
    @Mapping(target = "childInstitutionalPages", ignore = true) // will be set manually
    @Mapping(target = "hasUpdatedVersion", ignore = true) // will be set manually
    @Mapping(target = "parallelVersionStatus", ignore = true) // will be set manually
    @Mapping(target = "wpLeads", ignore = true) // will be set manually
    @Mapping(target = "members", ignore = true) // will be set manually
    @Mapping(target = "paragraphs", ignore = true) // will be set manually
    @Mapping(target = "workspaceFolderId", source = "entity.workspaceFolderId")
    @Mapping(target = "category", source = "entity.category")
    @Mapping(target = "copyright.text", source = "entity.copyrightText")
    @Mapping(target = "copyright.year", source = "entity.copyrightYear")
    @Mapping(target = "repositories.repoName", source = "entity.repoName")
    @Mapping(target = "repositories.website", source = "entity.website")
    @Mapping(target = "id", ignore = true) // will be set manually if needed
    @Mapping(target = "rootInstitutionalPageId", ignore = true) // will be set manually if needed
    OutputInstitutionalPageDto toDto(InstitutionalPageEntity entity);

    @Mapping(target = "institutionalPageId", source = "entity.id")
    @Mapping(target = "institutionalPageName", source = "entity.name")
    @Mapping(target = "isMember", source = "isMember")
    OutputRelatedInstitutionalPageDto toRelatedInstitutionalPageDto(InstitutionalPageEntity entity, boolean isMember);

    @Mapping(target = "published", ignore = true) // will be set manually if needed
    @Mapping(target = "parentInstitutionalPageId", ignore = true) // will be set manually if needed
    @Mapping(target = "ancestorInstitutionalPageIds", ignore = true) // will be set manually if needed
    @Mapping(target = "members", ignore = true) // will be set manually if needed
    @Mapping(target = "paragraphs", ignore = true) // will be set manually if needed
    @Mapping(target = "workspaceFolderId", ignore = true) // will be set manually if needed
    @Mapping(target = "moderationStatus", ignore = true) // will be set manually if needed
    @Mapping(target = "publicationTime", ignore = true) // will be set manually if needed
    @Mapping(target = "rejectionMessage", ignore = true) // will be set manually if needed
    @Mapping(target = "originalInstitutionalPageId", ignore = true) // will be set manually if needed
    @Mapping(target = "updatedInstitutionalPageId", ignore = true) // will be set manually if needed
    @Mapping(target = "updateLockedBy", ignore = true) // will be set manually if needed
    @Mapping(target = "lastModifiedBy", ignore = true) // will be set manually if needed
    @Mapping(target = "toDelete", ignore = true) // will be set manually
    @Mapping(target = "copyrightText", source = "copyright.text")
    @Mapping(target = "copyrightYear", source = "copyright.year")
    @Mapping(target = "repoName", source = "repositories.repoName")
    @Mapping(target = "website", source = "repositories.website")
    @Mapping(target = "id", ignore = true) // not updatable
    @Mapping(target = "creationTime", ignore = true) // will be set manually if needed
    @Mapping(target = "updateTime", ignore = true) // will be set manually if needed
    @Mapping(target = "version", ignore = true)
    void updateEntity(
            @MappingTarget InstitutionalPageEntity entity,
            InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto
    );

    @Mapping(target = "paragraphs", source = "paragraphs", qualifiedByName = "cloneParagraphList")
    @Mapping(target = "parentInstitutionalPageId", ignore = true) // not update
    @Mapping(target = "ancestorInstitutionalPageIds", ignore = true) // not update
    @Mapping(target = "workspaceFolderId", ignore = true) // not update
    @Mapping(target = "members", ignore = true) // not update
    @Mapping(target = "moderationStatus", ignore = true) // not update
    @Mapping(target = "publicationTime", ignore = true) // not update
    @Mapping(target = "rejectionMessage", ignore = true) // not update
    @Mapping(target = "originalInstitutionalPageId", ignore = true) // not update
    @Mapping(target = "updatedInstitutionalPageId", ignore = true) // not update
    @Mapping(target = "lastModifiedBy", ignore = true) // not update
    @Mapping(target = "id", ignore = true) // not updatable
    @Mapping(target = "creationTime", ignore = true) // not update
    @Mapping(target = "updateTime", ignore = true) // not update
    @Mapping(target = "version", ignore = true)
    void updateEntity(
            @MappingTarget InstitutionalPageEntity target,
            InstitutionalPageEntity src
    );

    @Mapping(target = "id", ignore = true) // not updatable
    @Mapping(target = "paragraphs", source = "paragraphs", qualifiedByName = "cloneParagraphList")
    @Mapping(target = "members", ignore = true)
    @Mapping(target = "rejectionMessage", ignore = true)
    @Mapping(target = "version", ignore = true)
    InstitutionalPageEntity clone(InstitutionalPageEntity source);

    SearchForMemberInstitutionalPageModel toModel(InputSearchForMemberInstitutionalPageDto source);

    @Mapping(target = "includePrivateAndMember", ignore = true) // will be set manually
    @Mapping(target = "includePublishedAndMember", ignore = true) // will be set manually
    @Mapping(target = "includePublishedAndNotMember", ignore = true) // will be set manually
    @Mapping(target = "wpLeaderOnly", ignore = true) // will be set manually
    SearchForMemberInstitutionalPageModel toModelForMember(InputSearchModerationInstitutionalPageDto source);

    @Mapping(target = "published", ignore = true) // will be set manually
    SearchInstitutionalPageModel toModel(InputSearchPublishedInstitutionalPageDto source);

    SearchInstitutionalPageModel toModel(InputSearchModerationInstitutionalPageDto source);

    @ValueMappings({
            @ValueMapping(source = "APPROVED", target = "APPROVED"),
            @ValueMapping(source = "PENDING", target = "PENDING"),
            @ValueMapping(source = "REJECTED", target = "REJECTED"),
            @ValueMapping(source = "DRAFT", target = "DRAFT"),
            @ValueMapping(source = "LATEST", target = MappingConstants.THROW_EXCEPTION),
            @ValueMapping(source = "ORIGINAL", target = MappingConstants.THROW_EXCEPTION)
    })
    ModerationStatus toModerationStatusEnum(InstitutionalPageView source);

    default String toModerationStatusLabel(ModerationStatus status) {
        return status != null ? status.getLabel() : null;
    }

}
