package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;

/**
 * Input DTO of repository links for the institutional page.
 */
@Schema(
        name = "InputRepositoriesDto",
        description = "Input DTO of repository links for the institutional page"
)
@Data
@Builder
@AllArgsConstructor
public class InputRepositoriesDto {

    @Schema(description = "URL of the source repository", example = "https://github.com/example/wp3-tres")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String repoName;

    @Schema(description = "URL of the website", example = "https://www.wp3tres.com")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String website;

}
