/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.api.MemberApi;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputInviteMembersDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPInvitationRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputRemoveMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSubmitJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPendingMemberRequestsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.MemberService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MemberController
implements MemberApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemberController.class);
    private final MemberService memberService;

    public OutputPendingMemberRequestsDto findPendingMemberRequestsForInstitutionalPage(UUID institutionalPageId) {
        log.debug("GET /api/v1/bs/institutional-page/institutional-pages/{}/members/requests", (Object)institutionalPageId);
        return this.memberService.findPendingMemberRequestsForInstitutionalPage(institutionalPageId);
    }

    public OutputPendingMemberRequestsDto findPendingMemberRequestsForUser() {
        log.debug("GET /api/v1/bs/institutional-page/institutional-pages/members/requests");
        return this.memberService.findPendingMemberRequestsForUser();
    }

    public OutputPendingMemberRequestsDto inviteMembers(UUID institutionalPageId, InputInviteMembersDto inputInviteMembersDto) {
        log.debug("POST /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/invitations, inputInviteMembersDto: {}", (Object)institutionalPageId, (Object)inputInviteMembersDto);
        return this.memberService.inviteMembers(institutionalPageId, inputInviteMembersDto);
    }

    public OutputPendingMemberRequestsDto cancelInvitation(UUID institutionalPageId, UUID invitedUserId) {
        log.debug("DELETE /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/invitations/{}", (Object)institutionalPageId, (Object)invitedUserId);
        return this.memberService.cancelInvitation(institutionalPageId, invitedUserId);
    }

    public OutputPendingMemberRequestsDto acceptOrRejectInvitation(UUID institutionalPageId, InputPatchIPInvitationRequestDto inputPatchIPInvitationRequestDto) {
        log.debug("PATCH /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/invitations, inputPatchIPInvitationRequestDto: {}", (Object)institutionalPageId, (Object)inputPatchIPInvitationRequestDto);
        return this.memberService.acceptOrRejectInvitation(institutionalPageId, inputPatchIPInvitationRequestDto);
    }

    public OutputInstitutionalPageDto patchMembershipOfUsersForInstitutionalPage(UUID institutionalPageId, InputPatchMembershipDto inputPatchMembershipDto) {
        log.debug("PATCH /api/v1/bs/institutional-page/institutional-pages/{}/members/membership, inputPatchMembershipDto: {}", (Object)institutionalPageId, (Object)inputPatchMembershipDto);
        return this.memberService.patchMembershipOfUsersForInstitutionalPage(institutionalPageId, inputPatchMembershipDto);
    }

    public OutputInstitutionalPageDto removeMembershipOfUsersForInstitutionalPage(UUID institutionalPageId, InputRemoveMembershipDto inputRemoveMembershipDto) {
        log.debug("DELETE /api/v1/dm/institutional-page/institutional-pages/{}/members/membership, inputRemoveMembershipDto: {}", (Object)institutionalPageId, (Object)inputRemoveMembershipDto);
        return this.memberService.removeMembershipOfUsersForInstitutionalPage(institutionalPageId, inputRemoveMembershipDto);
    }

    public OutputPendingMemberRequestsDto submitJoinRequest(UUID institutionalPageId, InputSubmitJoinRequestDto inputSubmitJoinRequestDto) {
        log.debug("POST /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/join, inputSubmitJoinRequestDto: {}", (Object)institutionalPageId, (Object)inputSubmitJoinRequestDto);
        return this.memberService.submitJoinRequest(institutionalPageId, inputSubmitJoinRequestDto);
    }

    public OutputPendingMemberRequestsDto cancelJoinRequest(UUID institutionalPageId) {
        log.debug("DELETE /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/join", (Object)institutionalPageId);
        return this.memberService.cancelJoinRequest(institutionalPageId);
    }

    public OutputPendingMemberRequestsDto acceptOrRejectJoinRequests(UUID institutionalPageId, InputPatchIPJoinRequestDto inputPatchIPJoinRequestDto) {
        log.debug("PATCH /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/join, inputPatchIPJoinRequestDto: {}", (Object)institutionalPageId, (Object)inputPatchIPJoinRequestDto);
        return this.memberService.acceptOrRejectJoinRequests(institutionalPageId, inputPatchIPJoinRequestDto);
    }

    public OutputPageDto<OutputMembersInHierarchyDto> findAllUsersInHierarchy(UUID rootInstitutionalPageId, int pageNumber, int pageSize) {
        log.debug("GET /api/v1/bs/institutional-page/institutional-pages/{}/members/hierarchy, pageNumber: {}, pageSize: {}", new Object[]{rootInstitutionalPageId, pageNumber, pageSize});
        return this.memberService.findAllUsersInHierarchy(rootInstitutionalPageId, pageNumber, pageSize);
    }

    @Generated
    public MemberController(MemberService memberService) {
        this.memberService = memberService;
    }
}

