package com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper;

import com.finconsgroup.itserr.marketplace.catalog.bs.dto.ItemStatus;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputItemDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPublicationDto;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class, uses = {UserProfileMapper.class})
public interface PublicationMapper {

    @Mapping(target = "type", source = "type.name")
    @Mapping(target = "publicationDate", source = "publication.date")
    OutputPublicationDto toOutputPublicationDto(OutputItemDto dto);

    default String itemStatusToString(ItemStatus status) {
        if (status == null) {
            return null;
        }
        return status.getValue();
    }

}
