package com.finconsgroup.itserr.marketplace.favourite.user.dm.mapper;

import com.finconsgroup.itserr.marketplace.favourite.user.dm.entity.ArchivedFavouriteUserItemEntity;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.entity.FavouriteUserItemEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.springframework.lang.NonNull;

/**
 * Mapper for all dto/entity conversions related to {@link ArchivedFavouriteUserItemEntity}
 */
@Mapper(config = MapperConfiguration.class)
public interface ArchivedFavouriteUserItemMapper {

    /**
     * Maps a {@link FavouriteUserItemEntity} to a {@link ArchivedFavouriteUserItemEntity}
     *
     * @param entity the source entity
     * @return the mapped entity
     */
    @Mapping(target = "archivalTime", ignore = true)
    ArchivedFavouriteUserItemEntity toArchiveEntity(@NonNull FavouriteUserItemEntity entity);
}
