/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.bean.DetailRequest;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.client.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.FavouriteUserBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people.OutputPeopleFavouriteDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemDetailProviderRegistry;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.impl.AbstractFavouriteUserItemDetailProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FavouriteUserItemPeopleDetailProvider
extends AbstractFavouriteUserItemDetailProvider<OutputPeopleFavouriteDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FavouriteUserItemPeopleDetailProvider.class);
    private final UserProfileDmClient userProfileDmClient;

    public FavouriteUserItemPeopleDetailProvider(@NonNull FavouriteUserItemDetailProviderRegistry favouriteUserItemDetailProviderRegistry, @NonNull UserProfileDmClient userProfileDmClient, @NonNull FavouriteUserBsProperties favouriteUserBsProperties) {
        super(favouriteUserItemDetailProviderRegistry, favouriteUserBsProperties, ItemContext.PEOPLE);
        Objects.requireNonNull(userProfileDmClient, "userProfileDmClient must not be null");
        this.userProfileDmClient = userProfileDmClient;
    }

    @NonNull
    public OutputPeopleFavouriteDto getDetailById(@NonNull String itemId) {
        Objects.requireNonNull(itemId, "itemId must not be null");
        InputFindUserProfilesByIdsDto inputFindUserProfilesByIdsDto = InputFindUserProfilesByIdsDto.builder().ids(List.of(UUID.fromString(itemId))).build();
        OutputPageDto outputUserProfileDtos = this.userProfileDmClient.findAllByIds(inputFindUserProfilesByIdsDto, 0, 1, "id", SortDirection.ASC);
        if (CollectionUtils.isEmpty((Collection)outputUserProfileDtos.getContent())) {
            throw new WP2ResourceNotFoundException("Favourite user profile not found");
        }
        return this.mapFromUserProfileDto((OutputUserProfileDto)outputUserProfileDtos.getContent().getFirst());
    }

    @NonNull
    public OutputPageDto<OutputPeopleFavouriteDto> getDetails(@NonNull DetailRequest request) {
        if (request.getItemIds() == null || request.getItemIds().isEmpty()) {
            return OutputPageDto.emptyWithPageSize((int)request.getPageRequestDto().getPageSize());
        }
        InputFindUserProfilesByIdsDto inputFindUserProfilesByIdsDto = InputFindUserProfilesByIdsDto.builder().ids(request.getItemIds().stream().map(UUID::fromString).toList()).build();
        return this.userProfileDmClient.findAllByIds(inputFindUserProfilesByIdsDto, request.getPageRequestDto().getPageNumber(), request.getPageRequestDto().getPageSize(), request.getPageRequestDto().getSort(), request.getPageRequestDto().getDirection()).map(arg_0 -> this.mapFromUserProfileDto(arg_0));
    }

    private OutputPeopleFavouriteDto mapFromUserProfileDto(OutputUserProfileDto userProfileDto) {
        return OutputPeopleFavouriteDto.builder().id(userProfileDto.getId()).firstName(userProfileDto.getFirstName()).lastName(userProfileDto.getLastName()).imageUrl(userProfileDto.getImageUrl()).orcid(userProfileDto.getOrcid()).shortBio(userProfileDto.getShortBio()).organizationAffiliation(userProfileDto.getOrganizationAffiliation()).ssd(userProfileDto.getSsd()).expertises(userProfileDto.getExpertises()).creationTime(userProfileDto.getCreationTime()).updateTime(userProfileDto.getUpdateTime()).language(userProfileDto.getLanguage()).build();
    }
}

