/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.FavouriteItemMessageBodyDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.ResourceByFolloweeMessageBodyDto;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="false")
public class LoggerEventProducer
implements EventProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggerEventProducer.class);

    public void publishFavouriteItemCreatedEvent(@NonNull FavouriteItemMessageBodyDto favouriteItem) {
        log.info("Message dispatch skipped (local profile) - Created event for favourite item: {}", (Object)favouriteItem);
    }

    public void publishFavouriteItemUpdatedEvent(@NonNull FavouriteItemMessageBodyDto favouriteItem) {
        log.info("Message dispatch skipped (local profile) - Updated event for favourite item: {}", (Object)favouriteItem);
    }

    public void publishFavouriteItemDeletedEvent(@NonNull FavouriteItemMessageBodyDto favouriteItem) {
        log.info("Message dispatch skipped (local profile) - Deleted event for favourite item: {}", (Object)favouriteItem);
    }

    public void publishResourceCreatedByFolloweeEvent(@NonNull ResourceByFolloweeMessageBodyDto resourceByFollowee) {
        log.info("Message dispatch skipped (local profile) - Resource created by followee event: {}", (Object)resourceByFollowee);
    }
}

