package com.finconsgroup.itserr.marketplace.favourite.user.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.bean.DetailRequest;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.client.InstitutionalPageBsClient;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.FavouriteUserBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.ModerationStatusInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.OutputInstitutionalPageFavouriteDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemDetailProvider;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemDetailProviderRegistry;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

/**
 * Implementation of {@link FavouriteUserItemDetailProvider} for Institutional Pages
 */
@Service
@Slf4j
public class FavouriteUserItemPageDetailProvider extends AbstractFavouriteUserItemDetailProvider<OutputInstitutionalPageFavouriteDto> {

    private final InstitutionalPageBsClient institutionalPageBsClient;

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    public FavouriteUserItemPageDetailProvider(@NonNull FavouriteUserItemDetailProviderRegistry favouriteUserItemDetailProviderRegistry,
                                               @NonNull InstitutionalPageBsClient institutionalPageBsClient,
                                               @NonNull FavouriteUserBsProperties favouriteUserBsProperties) {
        super(favouriteUserItemDetailProviderRegistry, favouriteUserBsProperties, ItemContext.INSTITUTIONAL_PAGE);
        Objects.requireNonNull(institutionalPageBsClient, "pageDmClient must not be null");

        this.institutionalPageBsClient = institutionalPageBsClient;
    }

    @NonNull
    @Override
    public OutputInstitutionalPageFavouriteDto getDetailById(@NonNull String itemId) {
        Objects.requireNonNull(itemId, "itemId must not be null");

        List<UUID> ids = List.of(UUID.fromString(itemId));
        OutputPageDto<OutputInstitutionalPageFavouriteDto> outputInstitutionalPageFavouritePageDto = institutionalPageBsClient.search(
                ModerationStatusInstitutionalPageDto.APPROVED, buildSearchRequest(ids), Set.of("wpLeads"), 0, 1, "id", SortDirection.ASC);

        if (CollectionUtils.isEmpty(outputInstitutionalPageFavouritePageDto.getContent())) {
            throw new WP2ResourceNotFoundException("Favourite institutional page not found");
        }

        return outputInstitutionalPageFavouritePageDto.getContent().getFirst();
    }

    @NonNull
    @Override
    public OutputPageDto<OutputInstitutionalPageFavouriteDto> getDetails(@NonNull DetailRequest request) {
        // avoid calling the business service if there are no item ids in the request
        if (request.getItemIds() == null || request.getItemIds().isEmpty()) {
            return OutputPageDto.emptyWithPageSize(request.getPageRequestDto().getPageSize());
        }

        List<UUID> ids = request.getItemIds().stream().map(UUID::fromString).toList();

        return institutionalPageBsClient.search(
                ModerationStatusInstitutionalPageDto.APPROVED,
                buildSearchRequest(ids),
                Set.of("wpLeads"),
                request.getPageRequestDto().getPageNumber(),
                request.getPageRequestDto().getPageSize(),
                request.getPageRequestDto().getSort(),
                request.getPageRequestDto().getDirection());
    }

    private InputSearchForMemberInstitutionalPageDto buildSearchRequest(List<UUID> ids) {
        return InputSearchForMemberInstitutionalPageDto.builder()
                .ids(ids)
                .includePrivateAndMember(true)
                .includePublishedAndMember(true)
                .includePublishedAndNotMember(true)
                .build();
    }
}
