package com.finconsgroup.itserr.marketplace.favouritesearch.bs.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidJsonValidator implements ConstraintValidator<ValidJson, String> {

    private final ObjectMapper objectMapper;

    @Autowired
    public ValidJsonValidator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.trim().isEmpty()) {
            return true;
        }

        try {
            JsonNode node = objectMapper.readTree(value);
            return node.isObject() || node.isArray();
        } catch (Exception e) {
            return false;
        }
    }
}

