package com.finconsgroup.itserr.marketplace.event.dm.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * Utility class for date time related functions
 */
public final class StreamUtils {

    public static <T> Stream<T> safeStream(Collection<T> collection) {
        return Optional.ofNullable(collection)
                .orElse(Collections.emptyList())
                .stream()
                .filter(Objects::nonNull);
    }
}
