package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedSubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.SubscribedParticipantEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface ArchivedSubscribedParticipantMapper {

    /**
     * Maps a {@link SubscribedParticipantEntity} into a {@link ArchivedSubscribedParticipantEntity}.
     *
     * @param src Source request.
     * @return Mapped entity.
     */
    @Mapping(target = "archiveTime", ignore = true)
    @Mapping(target = "event", ignore = true)
    ArchivedSubscribedParticipantEntity toArchivedSubscribedParticipantEntity(SubscribedParticipantEntity src);
}
