/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramSubscribedParticipantEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="archived_program_subscribed_participant")
public class ArchivedProgramSubscribedParticipantEntity
extends AbstractUUIDEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="program_id", updatable=false)
    private ArchivedProgramEntity program;
    @Column(name="user_id", updatable=false)
    private UUID userId;
    @Column(name="remote_participation", updatable=false)
    private Boolean remoteParticipation;
    @Column(name="creation_time", nullable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Column(name="archive_time", nullable=false)
    private Instant archiveTime;
    @Column(name="version", nullable=false)
    private long version;
    @Column(name="participant_order", nullable=false)
    private long participantOrder;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
        if (this.archiveTime == null) {
            this.archiveTime = now;
        }
    }

    @Generated
    protected ArchivedProgramSubscribedParticipantEntity(ArchivedProgramSubscribedParticipantEntityBuilder<?, ?> b) {
        super(b);
        this.program = b.program;
        this.userId = b.userId;
        this.remoteParticipation = b.remoteParticipation;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.archiveTime = b.archiveTime;
        this.version = b.version;
        this.participantOrder = b.participantOrder;
    }

    @Generated
    public static ArchivedProgramSubscribedParticipantEntityBuilder<?, ?> builder() {
        return new ArchivedProgramSubscribedParticipantEntityBuilderImpl();
    }

    @Generated
    public ArchivedProgramEntity getProgram() {
        return this.program;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public Boolean getRemoteParticipation() {
        return this.remoteParticipation;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public Instant getArchiveTime() {
        return this.archiveTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public long getParticipantOrder() {
        return this.participantOrder;
    }

    @Generated
    public void setProgram(ArchivedProgramEntity program) {
        this.program = program;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setRemoteParticipation(Boolean remoteParticipation) {
        this.remoteParticipation = remoteParticipation;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setArchiveTime(Instant archiveTime) {
        this.archiveTime = archiveTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public void setParticipantOrder(long participantOrder) {
        this.participantOrder = participantOrder;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivedProgramSubscribedParticipantEntity)) {
            return false;
        }
        ArchivedProgramSubscribedParticipantEntity other = (ArchivedProgramSubscribedParticipantEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getParticipantOrder() != other.getParticipantOrder()) {
            return false;
        }
        Boolean this$remoteParticipation = this.getRemoteParticipation();
        Boolean other$remoteParticipation = other.getRemoteParticipation();
        if (this$remoteParticipation == null ? other$remoteParticipation != null : !((Object)this$remoteParticipation).equals(other$remoteParticipation)) {
            return false;
        }
        ArchivedProgramEntity this$program = this.getProgram();
        ArchivedProgramEntity other$program = other.getProgram();
        if (this$program == null ? other$program != null : !this$program.equals(other$program)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Instant this$archiveTime = this.getArchiveTime();
        Instant other$archiveTime = other.getArchiveTime();
        return !(this$archiveTime == null ? other$archiveTime != null : !((Object)this$archiveTime).equals(other$archiveTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivedProgramSubscribedParticipantEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        long $participantOrder = this.getParticipantOrder();
        result = result * 59 + (int)($participantOrder >>> 32 ^ $participantOrder);
        Boolean $remoteParticipation = this.getRemoteParticipation();
        result = result * 59 + ($remoteParticipation == null ? 43 : ((Object)$remoteParticipation).hashCode());
        ArchivedProgramEntity $program = this.getProgram();
        result = result * 59 + ($program == null ? 43 : $program.hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Instant $archiveTime = this.getArchiveTime();
        result = result * 59 + ($archiveTime == null ? 43 : ((Object)$archiveTime).hashCode());
        return result;
    }

    @Generated
    public ArchivedProgramSubscribedParticipantEntity() {
    }
}

