package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputProgramConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputProgramDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputProgramSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramConductorEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramSubscribedParticipantEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-01-02T19:27:19+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class ProgramMapperImpl implements ProgramMapper {

    @Autowired
    private ProgramConductorMapper programConductorMapper;

    @Override
    public ProgramEntity toEntity(InputProgramDto inputProgramDto) {
        if ( inputProgramDto == null ) {
            return null;
        }

        ProgramEntity.ProgramEntityBuilder<?, ?> programEntity = ProgramEntity.builder();

        programEntity.title( inputProgramDto.getTitle() );
        programEntity.description( inputProgramDto.getDescription() );
        programEntity.programLink( inputProgramDto.getProgramLink() );
        programEntity.place( inputProgramDto.getPlace() );
        programEntity.street( inputProgramDto.getStreet() );
        programEntity.houseNumber( inputProgramDto.getHouseNumber() );
        programEntity.startTime( inputProgramDto.getStartTime() );
        programEntity.endTime( inputProgramDto.getEndTime() );
        programEntity.maxParticipants( inputProgramDto.getMaxParticipants() );
        programEntity.programConductors( inputProgramConductorDtoListToProgramConductorEntityList( inputProgramDto.getProgramConductors() ) );

        return programEntity.build();
    }

    @Override
    public OutputProgramDto toDto(ProgramEntity programEntity) {
        if ( programEntity == null ) {
            return null;
        }

        OutputProgramDto.OutputProgramDtoBuilder<?, ?> outputProgramDto = OutputProgramDto.builder();

        outputProgramDto.id( programEntity.getId() );
        outputProgramDto.title( programEntity.getTitle() );
        outputProgramDto.description( programEntity.getDescription() );
        outputProgramDto.programLink( programEntity.getProgramLink() );
        outputProgramDto.programConductors( programConductorEntityListToOutputProgramConductorDtoList( programEntity.getProgramConductors() ) );
        outputProgramDto.place( programEntity.getPlace() );
        outputProgramDto.street( programEntity.getStreet() );
        outputProgramDto.houseNumber( programEntity.getHouseNumber() );
        outputProgramDto.maxParticipants( programEntity.getMaxParticipants() );
        outputProgramDto.subscribedParticipants( programSubscribedParticipantEntityListToOutputProgramSubscribedParticipantDtoList( programEntity.getSubscribedParticipants() ) );
        outputProgramDto.subscribedParticipantsCount( programEntity.getSubscribedParticipantsCount() );
        outputProgramDto.startTime( programEntity.getStartTime() );
        outputProgramDto.endTime( programEntity.getEndTime() );

        return outputProgramDto.build();
    }

    @Override
    public void updateEntity(InputProgramDto dto, ProgramEntity entity) {
        if ( dto == null ) {
            return;
        }

        entity.setTitle( dto.getTitle() );
        entity.setDescription( dto.getDescription() );
        entity.setProgramLink( dto.getProgramLink() );
        entity.setPlace( dto.getPlace() );
        entity.setStreet( dto.getStreet() );
        entity.setHouseNumber( dto.getHouseNumber() );
        entity.setStartTime( dto.getStartTime() );
        entity.setEndTime( dto.getEndTime() );
        entity.setMaxParticipants( dto.getMaxParticipants() );
        if ( entity.getProgramConductors() != null ) {
            List<ProgramConductorEntity> list = inputProgramConductorDtoListToProgramConductorEntityList1( dto.getProgramConductors() );
            if ( list != null ) {
                entity.getProgramConductors().clear();
                entity.getProgramConductors().addAll( list );
            }
            else {
                entity.setProgramConductors( null );
            }
        }
        else {
            List<ProgramConductorEntity> list = inputProgramConductorDtoListToProgramConductorEntityList1( dto.getProgramConductors() );
            if ( list != null ) {
                entity.setProgramConductors( list );
            }
        }
    }

    protected List<ProgramConductorEntity> inputProgramConductorDtoListToProgramConductorEntityList(List<InputProgramConductorDto> list) {
        if ( list == null ) {
            return null;
        }

        List<ProgramConductorEntity> list1 = new ArrayList<ProgramConductorEntity>( list.size() );
        for ( InputProgramConductorDto inputProgramConductorDto : list ) {
            list1.add( programConductorMapper.toEntity( inputProgramConductorDto ) );
        }

        return list1;
    }

    protected List<OutputProgramConductorDto> programConductorEntityListToOutputProgramConductorDtoList(List<ProgramConductorEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<OutputProgramConductorDto> list1 = new ArrayList<OutputProgramConductorDto>( list.size() );
        for ( ProgramConductorEntity programConductorEntity : list ) {
            list1.add( programConductorMapper.toDto( programConductorEntity ) );
        }

        return list1;
    }

    protected OutputProgramSubscribedParticipantDto programSubscribedParticipantEntityToOutputProgramSubscribedParticipantDto(ProgramSubscribedParticipantEntity programSubscribedParticipantEntity) {
        if ( programSubscribedParticipantEntity == null ) {
            return null;
        }

        OutputProgramSubscribedParticipantDto.OutputProgramSubscribedParticipantDtoBuilder<?, ?> outputProgramSubscribedParticipantDto = OutputProgramSubscribedParticipantDto.builder();

        outputProgramSubscribedParticipantDto.id( programSubscribedParticipantEntity.getId() );
        outputProgramSubscribedParticipantDto.programId( programSubscribedParticipantEntity.getProgramId() );
        outputProgramSubscribedParticipantDto.userId( programSubscribedParticipantEntity.getUserId() );
        outputProgramSubscribedParticipantDto.remoteParticipation( programSubscribedParticipantEntity.getRemoteParticipation() );
        outputProgramSubscribedParticipantDto.creationTime( programSubscribedParticipantEntity.getCreationTime() );
        outputProgramSubscribedParticipantDto.updateTime( programSubscribedParticipantEntity.getUpdateTime() );

        return outputProgramSubscribedParticipantDto.build();
    }

    protected List<OutputProgramSubscribedParticipantDto> programSubscribedParticipantEntityListToOutputProgramSubscribedParticipantDtoList(List<ProgramSubscribedParticipantEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<OutputProgramSubscribedParticipantDto> list1 = new ArrayList<OutputProgramSubscribedParticipantDto>( list.size() );
        for ( ProgramSubscribedParticipantEntity programSubscribedParticipantEntity : list ) {
            list1.add( programSubscribedParticipantEntityToOutputProgramSubscribedParticipantDto( programSubscribedParticipantEntity ) );
        }

        return list1;
    }

    protected List<ProgramConductorEntity> inputProgramConductorDtoListToProgramConductorEntityList1(List<InputProgramConductorDto> list) {
        if ( list == null ) {
            return new ArrayList<ProgramConductorEntity>();
        }

        List<ProgramConductorEntity> list1 = new ArrayList<ProgramConductorEntity>( list.size() );
        for ( InputProgramConductorDto inputProgramConductorDto : list ) {
            list1.add( programConductorMapper.toEntity( inputProgramConductorDto ) );
        }

        return list1;
    }
}
