package com.finconsgroup.itserr.marketplace.event.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.event.dm.api.ProgramApi;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.service.ProgramService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling user event related API requests.
 *
 * <p>Implements the {@link ProgramApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class ProgramController implements ProgramApi {

    private final ProgramService programService;

    @Override
    public OutputEventDto registerProgram(UUID eventId, UUID programId, InputProgramSubscribedParticipantDto dto) {
        return programService.register(JwtTokenHolder.getUserIdOrThrow(), eventId, programId, dto);
    }

    @Override
    public OutputEventDto unregisterProgram(UUID eventId, UUID programId) {
        return programService.unregister(JwtTokenHolder.getUserIdOrThrow(), eventId, programId);
    }
}
