/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="ProgramApi", description="The ProgramApi API: it provides endpoints to register and unregister to a program.")
@SecurityRequirement(name="BearerAuth")
public interface ProgramApi {
    @Operation(summary="register a user to a program", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PostMapping(value={"/event/events/{eventId}/programs/{programId}/register"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputEventDto registerProgram(@PathVariable(value="eventId") UUID var1, @PathVariable(value="programId") UUID var2, @Valid @RequestBody InputProgramSubscribedParticipantDto var3);

    @Operation(summary="unregister a user to a program", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @DeleteMapping(value={"/event/events/{eventId}/programs/{programId}/register"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputEventDto unregisterProgram(@PathVariable(value="eventId") UUID var1, @PathVariable(value="programId") UUID var2);
}

