package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.UUID;

/**
 * Output DTO for subscribed program.
 */
@Schema(name = "OutputSubscribedProgramDto",
        description = "DTO representing a program that the participant has subscribed to, used in API responses"
)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputSubscribedProgramDto {

    @Schema(description = "Unique identifier of the program", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "The title of the program", example = "Java Webinar")
    private String title;

    @Schema(description = "The description of the program", example = "Webinar on java new and breaking changes")
    private String description;

    @Schema(description = "True, if the participant is attending remotely (online)", example = "false")
    private Boolean remoteParticipation;
}
