/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.event.bs.configuration.properties.EventBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultResourceProducer
implements ResourceProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceProducer.class);
    private final MessageProducer messageProducer;
    private final EventBsConfigurationProperties.Messaging messagingProperties;

    public DefaultResourceProducer(EventBsConfigurationProperties bsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = bsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getProducerName());
    }

    public void publishCreatedResource(@NotNull OutputEventDto resource) {
        this.publish(resource, this.messagingProperties.getResourceCreatedType());
    }

    public void publishUpdatedResource(@NotNull OutputEventDto resource) {
        this.publish(resource, this.messagingProperties.getResourceUpdatedType());
    }

    public void publishDeletedResource(@NotNull OutputEventDto resource) {
        this.publish(resource, this.messagingProperties.getResourceDeletedType());
    }

    private void publish(@NonNull OutputEventDto resource, @NonNull String eventType) {
        try {
            Map<String, OutputEventDto> messageMap = Map.of(resource.getId().toString(), resource);
            Map<String, String> filterProperties = Map.of("service", "event");
            log.debug("Sending message, messageMap: {}, eventType: {}, source: {}, filterProperties: {}", new Object[]{messageMap, eventType, this.messagingProperties.getSource(), filterProperties});
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published message for resource with id: {}", (Object)resource.getId());
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage);
        }
    }
}

