package com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum InstitutionalPageView {
    ORIGINAL("Original"),
    LATEST("Latest"),
    APPROVED("Approved"),
    PENDING("Pending"),
    REJECTED("Rejected"),
    DRAFT("Draft");

    private final String label;

    InstitutionalPageView(String label) {
        this.label = label;
    }

    @JsonValue
    public String getLabel() {
        return label;
    }

    /**
     * It maps the label to a {@link InstitutionalPageView} object
     *
     * @param label the label to map to enum
     * @return {@link InstitutionalPageView} instance if found
     * @throws IllegalArgumentException if no matching instance found
     */
    public static InstitutionalPageView ofLabel(String label) {
        for (InstitutionalPageView institutionalPageView : InstitutionalPageView.values()) {
            if (institutionalPageView.label.equalsIgnoreCase(label)) {
                return institutionalPageView;
            }
        }

        throw new IllegalArgumentException("Unsupported value: " + label);
    }
}
