package com.finconsgroup.itserr.marketplace.event.bs.controller;

import com.finconsgroup.itserr.marketplace.event.bs.api.EventApi;
import com.finconsgroup.itserr.marketplace.event.bs.api.ImageApi;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputPublicImageDto;
import com.finconsgroup.itserr.marketplace.event.bs.service.ImageService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * REST controller class for handling user image related API requests.
 *
 * <p>Implements the {@link EventApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class ImageController implements ImageApi {
    private final ImageService imageService;

    @Override
    public OutputPublicImageDto createPublicImage(MultipartFile file) {
        return imageService.createPublicImage(file);
    }

    @Override
    public OutputPublicImageDto updatePublicImage(String id, MultipartFile file) {
        return imageService.updatePublicImage(id, file);
    }
}
