package com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

/**
 * Input DTO for searching Published institutionalPages.
 */
@Schema(
        name = "InputSearchPublishedInstitutionalPageDto",
        description = "Input DTO for searching Published institutionalPages"
)
@Data
@Builder
@AllArgsConstructor
public class InputSearchPublishedInstitutionalPageDto {

    /**
     * Filter to only return institutional pages matching the provided ids.
     */
    @Schema(
            description = "The ids of the institutional page, if present it should have at least one entry",
            example = "[\"11111111-aaaa-0000-0000-000000000000\"]"
    )
    private List<UUID> ids;

    /**
     * Filter to only return institutional pages matching the provided category
     */
    @Schema(
            description = "The category of the institutional page",
            allowableValues = {"tool", "project"},
            example = "project"
    )
    private String category;

    /**
     * Filter to only return root level i.e. top level institutional pages
     */
    @Schema(
            description = "The flag to indicate if only top level institutional pages should be returned",
            example = "true"
    )
    private Boolean rootLevelOnly;

    /**
     * The text used to filter institutional pages by name
     */
    @Schema(
            description = "The text used to filter institutional pages by name",
            example = "T-Res"
    )
    private String searchText;
}
