/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.event.bs.client.WorkspaceBsClient;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.workspace.FolderDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.workspace.InputFolderCreateDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.workspace.OutputPublicImageWSDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.workspace.WorkspaceDto;
import com.finconsgroup.itserr.marketplace.event.bs.configuration.properties.EventBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputPublicImageDto;
import com.finconsgroup.itserr.marketplace.event.bs.service.ImageService;
import feign.FeignException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultImageService
implements ImageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultImageService.class);
    private final WorkspaceBsClient workspaceBsClient;
    private final EventBsConfigurationProperties eventBsConfigurationProperties;

    public DefaultImageService(WorkspaceBsClient workspaceBsClient, EventBsConfigurationProperties eventBsConfigurationProperties) {
        this.workspaceBsClient = workspaceBsClient;
        this.eventBsConfigurationProperties = eventBsConfigurationProperties;
    }

    @NonNull
    public OutputPublicImageDto createPublicImage(@NonNull MultipartFile file) {
        String folderId = this.getOrCreateImagesFolder();
        OutputPublicImageWSDto wsOutputPublicImageWSDto = this.workspaceBsClient.createPublicImage(folderId, file);
        return DefaultImageService.mapWsOutputPublicImageDto((OutputPublicImageWSDto)wsOutputPublicImageWSDto);
    }

    @NonNull
    public OutputPublicImageDto updatePublicImage(@NonNull String id, @NonNull MultipartFile file) {
        OutputPublicImageWSDto wsOutputPublicImageWSDto = this.workspaceBsClient.updatePublicImage(id, file);
        return DefaultImageService.mapWsOutputPublicImageDto((OutputPublicImageWSDto)wsOutputPublicImageWSDto);
    }

    private String getOrCreateImagesFolder() {
        WorkspaceDto workspace = this.workspaceBsClient.getWorkspace();
        String imagesFolderName = this.eventBsConfigurationProperties.getImagesFolderName();
        try {
            FolderDto folder = this.workspaceBsClient.getFolderByParentFolderIdAndName(workspace.getId(), imagesFolderName);
            return folder.getId();
        }
        catch (WP2ResourceNotFoundException | FeignException.NotFound e) {
            InputFolderCreateDto inputFolderCreateDto = InputFolderCreateDto.builder().name(imagesFolderName).description(imagesFolderName).hidden(Boolean.valueOf(true)).build();
            return this.workspaceBsClient.createFolderByFolderId(workspace.getId(), inputFolderCreateDto);
        }
    }

    private static OutputPublicImageDto mapWsOutputPublicImageDto(OutputPublicImageWSDto wsOutputPublicImageWSDto) {
        return OutputPublicImageDto.builder().id(wsOutputPublicImageWSDto.getId()).publicLink(wsOutputPublicImageWSDto.getPublicLink()).build();
    }
}

