/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.echo.dm.websocket;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import io.micrometer.common.util.StringUtils;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Component
public class WsHandshakeInterceptor
implements HandshakeInterceptor {
    public static final String USER_ID_ATTR = "userId";
    public static final String USERNAME_ATTR = "username";

    public boolean beforeHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, @NonNull Map<String, Object> attributes) throws Exception {
        UUID userId = JwtTokenHolder.getUserId().orElse(null);
        String username = JwtTokenHolder.getPreferredUsername().orElse(null);
        if (userId == null || StringUtils.isBlank((String)username)) {
            return false;
        }
        attributes.put(USER_ID_ATTR, userId);
        attributes.put(USERNAME_ATTR, username);
        return true;
    }

    public void afterHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, Exception exception) {
    }
}

