package com.finconsgroup.itserr.marketplace.echo.dm.service.impl;

import com.finconsgroup.itserr.marketplace.echo.dm.service.OrderService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * Default implementation of {@link OrderService}
 * to perform operations related to order resources
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultOrderService implements OrderService {

    @Override
    public String findAllUsers(Map<String, String> headers) {
        String str = "call to GET /users - findAllUsers";
        return getResponse(str, headers);
    }

    @Override
    public String deleteAllUsers(Map<String, String> headers) {
        String str = "call to DELETE /users - deleteAllUsers";
        return getResponse(str, headers);
    }

    @Override
    public String findUserByUserId(String userId, Map<String, String> headers) {
        String str = "call to GET /users/%s - findUserByUserId".formatted(userId);
        return getResponse(str, headers);
    }

    @Override
    public String deleteUserByUserId(String userId, Map<String, String> headers) {
        String str = "call to DELETE /users/%s - deleteUserByUserId".formatted(userId);
        return getResponse(str, headers);
    }

    @Override
    public String findAllOrdersByUserId(String userId, Map<String, String> headers) {
        String str = "call to GET /users/%s/orders - findAllOrdersByUserId".formatted(userId);
        return getResponse(str, headers);
    }

    @Override
    public String deleteAllOrdersByUserId(String userId, Map<String, String> headers) {
        String str = "call to DELETE /users/%s/orders - deleteAllOrdersByUserId".formatted(userId);
        return getResponse(str, headers);
    }

    @Override
    public String findOrderByUserIdAndOrderId(String userId, String orderId, Map<String, String> headers) {
        String str = "call to GET /users/%s/orders/%s - findOrderByUserIdAndOrderId".formatted(userId, orderId);
        return getResponse(str, headers);
    }

    @Override
    public String deleteOrderByUserIdAndOrderId(String userId, String orderId, Map<String, String> headers) {
        String str = "call to DELETE /users/%s/orders/%s - deleteOrderByUserIdAndOrderId".formatted(userId, orderId);
        return getResponse(str, headers);
    }

    // private

    private static String getResponse(String str, Map<String, String> headers) {
        StringBuilder s = new StringBuilder(str);
        s.append("\nStart Request Header\n");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String line = "- " + entry.getKey() + " : " + entry.getValue();
            s.append(line).append("\n");
        }
        s.append("End Request Header\n");
        return s.toString();
    }

}
